
//////////////////////////////////////////////////////////////////////
// CANshared.h
//////////////////////////////////////////////////////////////////////
//
//	Description: 
//	Shared memory structure with the CAN and the control module.	
//
//	Author: Dominic Letourneau
//	Creation Date: 2006/11/06
//
//	Modification history:
//
//	Name					Date        Descrition
//	Pierre Lepage			2008/05/14	Added InputCaptureH and L at Ram loc 19
//	Dominic	Letourneau		2008/02/04	Added variables to store ADC16bits values
//	Dominic	Letourneau		2008/02/04	Added setpoint with torque corr
//	Dominic Letourneau		2007/05/31	Added StartupMode
//	Dominic Letourneau		2007/05/10	Added ErrorCode
//  Dominic Letourneau		2007/05/09	Added A3935 Status & limit switches
//  Dominic Letourneau		2007/05/04	Added Basic CAN commands
//	Dominic Letourneau		2007/05/04	Added FeedbackTimeBase
//  Dominic Letourneau		2007/04/27	Added E-STOP variable
//  Dominic	Letourneau		2007/03/29	Added EXT1 & EXT2 offsets
//	Dominic	Letourneau		2007/02/08	Added switching mode
//	Dominic Letourneau		2007/02/08	Added motor and encoder bias
//  
//	
//////////////////////////////////////////////////////////////////////
//               Copyright by Laborius / RoboMotio  2007
//////////////////////////////////////////////////////////////////////

#ifndef _CAN_SHARED_H_
#define _CAN_SHARED_H_


/*
ACTUATOR HIGH PRIORITY COMMANDS
*/
#define CAN_ACTUATOR_CMD_POSITIONS	   0x90
#define CAN_ACTUATOR_CMD_SPEEDS 	   0x91
#define CAN_ACTUATOR_CMD_SETPOINTS	   0x92
#define CAN_ACTUATOR_CMD_WRITE_SETPOINT 0x93

//EEPROM CONFIG ADDRESS
#define CAN_EEPROM_STARTUP_PROFILE_ADDRESS   0x08
#define CAN_EEPROM_STARTUP_MODE_ADDRESS      0x09



//Watch out not to have more than 256 bytes of data (32 pages)
//Shared memory for every module
//Add variables here at the end for consistency with older versions...
typedef struct _SharedVariables
{
	//OFFSET 0	
	unsigned char CtrlMode;
	unsigned char CtrlType;
	unsigned char SetPointSource;	
	unsigned char PosMesSource;
	unsigned int ErrorCode;	
	signed int SetPoint;

	//OFFSET 8
	signed int SetPointMax; //Maximum SetPoint
	signed int SetPointMin; //Minimum SetPoint
	signed int Current;
	signed int CurrentOffset;


	//OFFSET 16
	signed int ADCValue;
	signed int ADCOffset;
	signed int ICValue;
	signed int ICOffset;

	//OFFSET 24
	signed int ThermalState;
	signed int Speed;//16 bit speed
	signed int Position; //16 bits position
	signed int Acceleration;
	

	//OFFSET 32
	signed int RefPoint; 
	signed int MesPoint;
	float pid_kp;

	//OFFSET 40
	float pid_ki;
	float pid_kd;

	//OFFSET 48
	float pid_error;
	float pid_error_accum;

	//OFFSET 56
	float pid_error_derivative;
	float pid_error_accum_max; //PID I value max limit (abs)

	//OFFSET 64
	signed int PIDOut;
	signed int SpeedMax; //for Trapz 
	signed int AccelerationStep; //for Trapz, Speed
	signed int InitPoint; //for Trapz

	//OFFSET 72
	signed int DestPoint; //for Trapz
	signed int NextPoint; //for Trapz
	signed int CurrentLimit; //unit = mA
	signed int PWM_CurrentLimit;

	//OFFSET 80
	signed int PWM_CurrentStep; //PWM increment
	unsigned char CurrentLimitActive;
	unsigned char EncoderBias; //Setting this to 1 will invert the encoder sign
	unsigned char MotorBias; //Setting this to 1 will invert motor polarity
	unsigned char padding[3];
} SharedVariables;

//Read & Write to this struct via CAN or Control
//extern SharedVariables g_sharedVariablesStruct[4];
//extern SharedVariables* const g_sharedVariables; 

/**
	Define all the variables for motor controllers
	and global variables
*/
typedef struct _GlobalVariables
{
	//Control variables for 4 drives
	SharedVariables m_sharedVariables[4];
	
	//ESTOP
	unsigned char m_ESTOPEnabled;

	//EEPROM REQUEST TIME
	unsigned char m_WriteEEPROM;


	int m_loopTime;

	unsigned char m_padding[4];
	
	
} GlobalVariables;

extern GlobalVariables g_globalVariables;



#endif
