#ifndef _DEVICE_H_
#define _DEVICE_H_

//device file
#include <p30f5011.h>

#define FREQ_CYCLE    20000000	// xtal = 10Mhz; PLLx8 -> 20 MIPS		
#define PWM_FREQUENCY 20000     // 20 kHz, so that no audible noise is present.

//DEVICE MEMORY MAP INFORMATION
#define EEPROM_BASE_ADDRESS_LOW 0xFC00
#define EEPROM_BASE_ADDRESS_HIGH 0x007F

//CONFIG IS AFTER THE FIRST 128 words / 256 bytes (EEPROM_DATA_TABLE FOR CAN DRIVER)
#define EEPROM_CONFIG_ADDRESS (EEPROM_BASE_ADDRESS_LOW + 256)

//WE CAN STORE UP TO 6 PROFILES 
#define EEPROM_CONFIG_PROFILE_COUNT 3
#define EEPROM_CONFIG_PROFILE_0 (EEPROM_BASE_ADDRESS_LOW + 256)
#define EEPROM_CONFIG_PROFILE_1 (EEPROM_BASE_ADDRESS_LOW + 512)
#define EEPROM_CONFIG_PROFILE_2 (EEPROM_BASE_ADDRESS_LOW + 768)



//FLASH ADDRESS OF BOOT LOADER
#define BOOT_LOADER_ADDRESS 0xA000

//USEFUL MACROS
#define Reset()    {__asm__ volatile ("reset");}

	

#endif
