//////////////////////////////////////////////////////////////////////
//  PID.c
//////////////////////////////////////////////////////////////////////
//
//  PID Control loop
//
//  Nom: Dominic Letourneau
//  Creation : 
//
// 	Modifications history :
//
//  Nom                  	Date        Descrition
//  Dominic Letourneau		2009/04/28	PID implementation with floating point
//  Dominic Letourneau		2007/09/12	New PID implementation using I limit.
//  Dominic Letourneau		2007/07/03 	Reset control history when coefs change
//	Dominic Letourneau		2007/02/08	Reset ControlOutput when all coefs == 0
//	Dominic Letourneau		2007/02/05	Generic implementation of PID
//	Dominic Letourneau		2007/02/05	Added pid_reset()
//////////////////////////////////////////////////////////////////////
//               Copyright by Laborius/RoboMotio  2006-2007
//////////////////////////////////////////////////////////////////////
#ifndef _PID_C_
#define _PID_C_

#include "Device.h"
#include "PID.h"
#include "limits.h"
#include <string.h>
#include "utils.h"

void pid_init(SharedVariables* variables)
{	
	pid_reset(variables);
}

void pid_calculate(SharedVariables* variables)
{
	//STORE OLD ERROR FOR DERIVATIVE
	float old_error = variables->pid_error;
	long mesValue = (long)variables->MesPoint;
	long refValue = (long)variables->RefPoint;


	//MAKE SURE ACCUM MAX IS POSTIVE
	variables->pid_error_accum_max = ABS(variables->pid_error_accum_max);

	//ERROR CALCULATION	(APPLY ERROR SATURATION)
	variables->pid_error = (float) (refValue - mesValue);

	//ERROR ACCUMULATOR (APPLY SATURATION)
	variables->pid_error_accum += variables->pid_error;

	//ACCUMULATOR SATURATION
	variables->pid_error_accum = MAX(MIN(variables->pid_error_accum,variables->pid_error_accum_max),-variables->pid_error_accum_max);

	//ERROR DERIVATIVE (APPLY SATURATION)
	variables->pid_error_derivative = variables->pid_error - old_error;

	//SET PID OUT
	variables->PIDOut = (signed int) (variables->pid_kp * variables->pid_error + variables->pid_ki * variables->pid_error_accum + variables->pid_kd * variables->pid_error_derivative);

}


void pid_reset(SharedVariables* variables)
{
	variables->pid_error_derivative = 0;
	variables->pid_error_accum = 0;
	variables->pid_error = 0;
	
	//Make sure output is 0
	variables->PIDOut = 0;
}

#endif
