#include "PWM.h"
#include "Device.h"
#include "utils.h"

int g_currentPWM[4] = {0,0,0,0};


//PWM MODULE WILL BE BASED ON TIMER 3
//INTERRUPT NOT REQUIRED RIGHT NOW
void __attribute__((interrupt(__save__(CORCON)),auto_psv)) _T3Interrupt (void)
{
	//Clear interrupt flag
	IFS0bits.T3IF = 0;

}

/**
	Timer3 is used for pwm modules. 
	//Prescaler 1:1, 1 tick = 50ns
*/
void pwm_init()
{
	//PWM OUTPUT PINS
	//RD0 = 2PWM, OC1
	//RD1 = 1PWM, OC2
	//RD2 = 3PWM, OC3
	//RD3 = 4PWM, OC4
	TRISDbits.TRISD0 = 0;
	TRISDbits.TRISD1 = 0;
	TRISDbits.TRISD2 = 0;
	TRISDbits.TRISD3 = 0;

	TRISFbits.TRISF6 = 1; //E-STOP


	//MOTOR DIRECTION PINS (OUTPUTS)
	TRISGbits.TRISG2 = 0; //IN1A
	TRISGbits.TRISG3 = 0; //IN1B
	TRISCbits.TRISC14 = 0; //DIAG1 OUTPUT
	LATCbits.LATC14 = 1; //ENABLE
	LATGbits.LATG2 = 0; //BRAKE MODE
	LATGbits.LATG3 = 0;

	TRISFbits.TRISF2 = 0; //IN2B
	TRISFbits.TRISF3 = 0; //IN2A
	TRISCbits.TRISC13 = 0; //DIAG2 OUTPUT
	LATCbits.LATC13 = 1; //ENABLE
	LATFbits.LATF2 = 0; //BRAKE MODE
	LATFbits.LATF3 = 0;

	TRISBbits.TRISB14 =0; //IN3B
	TRISBbits.TRISB15 =0; // IN3A
	TRISFbits.TRISF5 = 0; //DIAG3 OUTPUT
	LATFbits.LATF5 = 1; //ENABLE
	LATBbits.LATB14 = 0; //BRAKE MODE
	LATBbits.LATB15 = 0;

	TRISBbits.TRISB12 = 0; //IN4A
	TRISBbits.TRISB13 = 0; //IN4B
	TRISFbits.TRISF4 = 0; //DIAG4 OUTPUT
	LATFbits.LATF4 = 1; //ENABLE
	LATBbits.LATB12 = 0; //BRAKE MODE
	LATBbits.LATB13 = 0;

	//E-STOP (INPUT)
	TRISFbits.TRISF5 = 1; 

	//SETUP TIMER3 (NO INTERRUPT NEEDED)
	T3CONbits.TON = 0;		//Stop the timer 3.
	TMR3 = 0; 				//Reset the value of Timer 3
	T3CONbits.TSIDL = 0;	//Continue module operation in Idle mode
	T3CONbits.TGATE = 0;	//No GATE accumulation
	PR3 = 1000; //Period = 1000 tick = 20000KHz


	//SETUP OC1
	OC1CON = 0; // It is recommended that the user 
				// turn off the output compare module
				// before switching mode (Note 1, 14.3)
	OC1CONbits.OCSIDL = 0; //enabled in idle mode
	OC1CONbits.OCTSEL = 1; //Timer3 is the source clock
	OC1CONbits.OCM = 6; //110 = PWM mode on OCx, Fault pin disabled
	OC1RS = 0 ; //Duty cycle = 0


	//SETUP OC2
	OC2CON = 0; // It is recommended that the user 
				// turn off the output compare module
				// before switching mode (Note 1, 14.3)
	OC2CONbits.OCSIDL = 0; //enabled in idle mode
	OC2CONbits.OCTSEL = 1; //Timer3 is the source clock
	OC2CONbits.OCM = 6; //110 = PWM mode on OCx, Fault pin disabled	
	OC2RS = 0 ; //Duty cycle = 0
	
	//SETUP OC3
	OC3CON = 0; // It is recommended that the user 
				// turn off the output compare module
				// before switching mode (Note 1, 14.3)
	OC3CONbits.OCSIDL = 0; //enabled in idle mode
	OC3CONbits.OCTSEL = 1; //Timer3 is the source clock
	OC3CONbits.OCM = 6; //110 = PWM mode on OCx, Fault pin disabled	
	OC3RS = 0 ; //Duty cycle = 0


	//SETUP OC4
	OC4CON = 0; // It is recommended that the user 
				// turn off the output compare module
				// before switching mode (Note 1, 14.3)
	OC4CONbits.OCSIDL = 0; //enabled in idle mode
	OC4CONbits.OCTSEL = 1; //Timer3 is the source clock
	OC4CONbits.OCM = 6; //110 = PWM mode on OCx, Fault pin disabled	
	OC4RS = 0 ; //Duty cycle = 0


	//START TIMER3
	T3CONbits.TON = 1;
}

signed int getMaxDuty()
{
	int max_value = PR3 - 1;
	return max_value;
}

signed int getMinDuty()
{
	int min_val = PR3 - 1;
	return -min_val;
}

void setPWMDuty(MotorId id, signed int value)
{

	//limit pwm value
	int pwm_value = MIN(getMaxDuty(),MAX(getMinDuty(),value));

	//E-STOP test
	if (LATFbits.LATF6 == 0)
	{
	//	pwm_value = 0;
	}

	switch(id)
	{
		case MOTOR_1:
			OC2RS = ABS(pwm_value);
			if (pwm_value == 0)
			{
				//BRAKE
				LATGbits.LATG2 = 0; //IN1A
				LATGbits.LATG3 = 0; //IN1B
			}
			if (pwm_value > 0)
			{
				LATGbits.LATG2 = 1; //IN1A
				LATGbits.LATG3 = 0; //IN1B
			}
			else
			{
				LATGbits.LATG2 = 0; //IN1A
				LATGbits.LATG3 = 1; //IN1B
			}
			g_currentPWM[MOTOR_1] = pwm_value;
		break;

		case MOTOR_2:
			OC1RS = ABS(pwm_value);
			if (pwm_value == 0)
			{
				//BRAKE
				LATFbits.LATF3 = 0; //IN2A
				LATFbits.LATF2 = 0; //IN2B
			}
			if (pwm_value > 0)
			{
				LATFbits.LATF3 = 1; //IN2A
				LATFbits.LATF2 = 0; //IN2B
			}
			else
			{
				LATFbits.LATF3 = 0; //IN2A
				LATFbits.LATF2 = 1; //IN2B
			}
			g_currentPWM[MOTOR_2] = pwm_value;
		break;

		case MOTOR_3:
			OC3RS = ABS(pwm_value);
			if (pwm_value == 0)
			{
				//BRAKE
				LATBbits.LATB15 =0; //IN3A
				LATBbits.LATB14 =0; //IN3B
			}
			if (pwm_value > 0)
			{
				LATBbits.LATB15 =1; //IN3A
				LATBbits.LATB14 =0; //IN3B
			}
			else
			{
				LATBbits.LATB15 =0; //IN3A
				LATBbits.LATB14 =1; //IN3B
			}
			g_currentPWM[MOTOR_3] = pwm_value;
		break;

		case MOTOR_4:
			OC4RS = ABS(pwm_value);
			if (pwm_value == 0)
			{
				//BRAKE
				LATBbits.LATB12 = 0; //IN4A
				LATBbits.LATB13 = 0; //IN4B
			}
			else if (pwm_value > 0)
			{
				LATBbits.LATB12 = 1; //IN4A
				LATBbits.LATB13 = 0; //IN4B
			}
			else
			{
				LATBbits.LATB12 = 0; //IN4A
				LATBbits.LATB13 = 1; //IN4B
			}
			g_currentPWM[MOTOR_4] = pwm_value;
		break;

	}

}

signed int getPWMDuty(MotorId id)
{
	return g_currentPWM[id];
}

