//////////////////////////////////////////////////////////////////////
//   control.h
//////////////////////////////////////////////////////////////////////
//
//   Description: 
//   
//   Handle control modes 
//
//   Author: Dominic Letourneau, Pierre Lepage
//   Creation Date: 2006/22/06
//
//   Modification history:
//
//  Name					Date        Descrition
//	Dominic Letourneau		2006/02/08	Added reset & error mode
//	Dominic Letourneau		2006/02/06	Added code based on initial Brushless 
//                           			implementation for PIC18
//	Dominic Letourneau		2007/30/01	Added trapezoidal profile for position control					
//////////////////////////////////////////////////////////////////////
//               Copyright by Laborius / RoboMotio  2006
//////////////////////////////////////////////////////////////////////

#ifndef _CONTROL_H_
#define _CONTROL_H_

#include "CANShared.h"
#include "PWM.h"

//SET POINT SOURCES
typedef enum{SETPTSRC_CAN, SETPTSRC_AN1, SETPTSRC_AN2, SETPTSRC_AN3, SETPTSRC_AN4} SetPointSources;

//CONTROL MODES
typedef enum {CTRL_MODE_CONFIG, CTRL_MODE_NORMAL, CTRL_MODE_ERROR, CTRL_MODE_RESET} CTRLModes;


//CONTROL TYPES
typedef enum {CTRL_TYPE_OPEN_LOOP, CTRL_TYPE_POSITION, 
				CTRL_TYPE_POSITION_TRAPZ_PROFILE, 
				CTRL_TYPE_SPEED} CTRLType;

//MODE AND TYPE HANGLING
void control_main_handle(SharedVariables* variables, MotorId id);


#endif
