//////////////////////////////////////////////////////////////////////
//	memory.c
//////////////////////////////////////////////////////////////////////
//
//	Description: 
//	Memory driver for dsPIC devices		
//
//	Author: Dominic Letourneau
//	Creation Date: 2006/11/06
//
//	Modification history:
//
//	Name					Date        Descrition
//	Dominic	Letourneau		2009/04/30	Saving only GlobalVariables now
//	Dominic	Letourneau		2007/11/06	Profiles are now 256 bytes long instead of 128. Max 3 profiles.
//	Dominic Letourneau		2007/05/09	Better implementation for uneven size of shared variables, added profiles
//	Dominic Letourneau		2007/02/06	Added implementation of WriteSharedVariables 
//										and ReadSharedVariables
//  
//	
//////////////////////////////////////////////////////////////////////
//               Copyright by Laborius / RoboMotio  2006-2007
//////////////////////////////////////////////////////////////////////

#include "Device.h"
#include "memory.h"
#include "utils.h"

/*
	IMPORTANT NOTE:

	WE HAVE ENOUGH EEPROM TO SAVE EVERYTHING, EVEN
	IF THIS IS USELESS (VOLATILE INFORMATION)
	THE GOAL HERE IS TO AVOID CHANGING THIS FUNCTION WHEN WE ADD
	OR REMOVE VARIABLES IN THE SharedVariables STRUCT.


	 *** WARNING : WE MUST BE CAREFUL WHEN WE ADD VARIABLES. 
	THEY MUST BE ADDED AT THE END OF THE STRUCT TO HAVE COMPATIBLE INFORMATION BETWEEN PROGRAM VERSIONS.
	COMPATIBILITY MEANS TO HAVE THE SAME INFORMATION AT THE SAME EEPROM LOCATION. 
	IF COMPATIBILITY IS NOT A PROBLEM, DO WHATHEVER YOU WANT...

*/



void WriteGlobalVariables(GlobalVariables *variables)
{
	unsigned int i = 0;
	unsigned int *dataPtr = (unsigned int*) variables;	
	unsigned int config_address = EEPROM_CONFIG_ADDRESS;
	unsigned int size = sizeof(GlobalVariables);

	
	//LOOK FOR UNEVEN SIZE
	if (size & 0x0001)
	{
		size++;
	}
	
	//LOOK FOR MAXIMUM SIZE
	size = MIN(size +1,768);
	
	//Writing every element of the eeprom struct
	for (i = 0; i < size; i+=2)
	{
		//Avoid being interrupted
		__asm__ volatile ("disi #0x3FFF");
		WriteMem(EEPROM_BASE_ADDRESS_HIGH,config_address + i,dataPtr++,1);
		__asm__ volatile ("disi #0x0000");
	}
	
}


void ReadGlobalVariables(GlobalVariables *variables)
{
	unsigned int i = 0;
	unsigned int *dataPtr = (unsigned int*) variables;	
	unsigned int config_address = EEPROM_CONFIG_ADDRESS;
	unsigned int size = sizeof(GlobalVariables);

	//LOOK FOR UNEVEN SIZE
	if (size & 0x0001)
	{
		size++;
	}
	
	//LOOK FOR MAXIMUM SIZE
	size = MIN(size +1,768);

	//Reading every element of the eeprom struct
	for (i = 0; i < size; i+=2)
	{
		//Avoid being interrupted
		__asm__ volatile ("disi #0x3FFF");
		*dataPtr++ = ReadMem(EEPROM_BASE_ADDRESS_HIGH,config_address + i);
		__asm__ volatile ("disi #0x0000");
	}
	
}
