/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
*/

#ifndef _CAN_MESSAGE_H_
#define _CAN_MESSAGE_H_

/*
 MESSAGE PRIORITY DEFINITIONS
 */
#define CAN_PRIORITY_HIGHEST     0
#define CAN_PRIORITY_HIGH        1
#define CAN_PRIORITY_MEDIUM_HIGH 2
#define CAN_PRIORITY_MEDIUM      3
#define CAN_PRIORITY_MEDIUM_LOW  4
#define CAN_PRIORITY_LOW         5
#define CAN_PRIORITY_LOWEST      6
#define CAN_PRIORITY_EVENTS      7

/*
 MESSAGE TYPE DEFINITIONS
 */
#define CAN_TYPE_EMERGENCY                0x01
#define CAN_TYPE_ACTUATOR_HIGH_PRIORITY   0x02
#define CAN_TYPE_SENSOR_HIGH_PRIORITY     0x04
#define CAN_TYPE_ACTUATOR_LOW_PRIORITY    0x08
#define CAN_TYPE_SENSOR_LOW_PRIORITY      0x10
#define CAN_TYPE_REQUEST_DATA             0x20
#define CAN_TYPE_USER2                    0x40
#define CAN_TYPE_EVENTS                   0x80

/*
 ACTUATOR HIGH PRIORITY COMMANDS
 */
#define CAN_ACTUATOR_CMD_POSITIONS		0x90
#define CAN_ACTUATOR_CMD_SPEEDS			0x91
#define CAN_ACTUATOR_CMD_SETPOINTS		0x92
#define CAN_ACTUATOR_CMD_WRITE_SETPOINT 0x93

/*
 EMERGENCY MESSAGE COMMANDS (TYPE_EMERGENCY)
 */
#define CAN_EMERGENCY_CMD_RESET        0x00
#define CAN_EMERGENCY_CMD_STOP_ENABLE  0x01
#define CAN_EMERGENCY_CMD_DISCONNECT   0x02
#define CAN_EMERGENCY_CMD_RECONNECT    0x03
#define CAN_EMERGENCY_CMD_PROGRAM      0x04
#define CAN_EMERGENCY_CMD_STOP_DISABLE 0x05

#define CAN_REQUEST_READ                0x01
#define CAN_REQUEST_WRITE               0x00
#define CAN_REQUEST_EEPROM              0x01
#define CAN_REQUEST_RAM                 0x00

/*
 EVENTS MESSAGE COMMANDS (TYPE EVENTS)
 */

#define CAN_EVENTS_CMD_ALIVE           	0x00
#define CAN_EVENTS_CMD_REGISTER        	0x01  // unused
#define CAN_EVENTS_CMD_SILENCE			0x02


/*
 CAN ADDRESS DEFINITIONS
 */
#define CAN_ADDRESS_BROADCAST 0xFF


/*
 CAN DATA STRUCTURES
*/
class CANMessage 
{

public:
	
	unsigned char msg_priority;
	unsigned char msg_type;
	unsigned char msg_cmd;
	unsigned char msg_dest;
	unsigned char msg_remote;
	unsigned char msg_read_write;
	unsigned char msg_eeprom_ram;
	unsigned char msg_data_length;
	unsigned char msg_data[8];
	
	CANMessage()
	{
		msg_priority = 0;
		msg_type = 0;
		msg_cmd = 0;
		msg_dest = 0;
		msg_read_write = 0;
		msg_eeprom_ram = 0;
		msg_data_length = 0;
		
		for (int i = 0; i < 8; i++)
		{	
			msg_data[i] = 0;
		}	
	}
	
	CANMessage(const CANMessage &cpy)
	{
		
		msg_priority = cpy.msg_priority;
		msg_type = cpy.msg_type;
		msg_cmd = cpy.msg_cmd;
		msg_dest = cpy.msg_dest;
		msg_read_write = cpy.msg_read_write;
		msg_eeprom_ram = cpy.msg_eeprom_ram;
		msg_data_length = cpy.msg_data_length;
		
		for (int i = 0; i < 8; i++)
		{	
			msg_data[i] = cpy.msg_data[i];
		}	
	}	
	
	CANMessage& operator= (const CANMessage&cpy)
	{
		msg_priority = cpy.msg_priority;
		msg_type = cpy.msg_type;
		msg_cmd = cpy.msg_cmd;
		msg_dest = cpy.msg_dest;
		msg_read_write = cpy.msg_read_write;
		msg_eeprom_ram = cpy.msg_eeprom_ram;
		msg_data_length = cpy.msg_data_length;
		
		for (int i = 0; i < 8; i++)
		{	
			msg_data[i] = cpy.msg_data[i];
		}
		return *this;
	}
	
};

#endif

