/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
*/
#ifndef _MAIN_WINDOW_H_
#define _MAIN_WINDOW_H_

#include <QMainWindow>
#include <QMessageBox>
#include "ui_Mainwindow.h"
#include "ui_MRA.h"
#include "ui_MLA.h"
#include "ui_MRN.h"
#include "DriveView.h"
#include "SerialDriver.h"
#include <QTimer>
#include "SharedVariables.h"
#define NB_DRIVE 4

class MainWindow : public QMainWindow, public Ui::MainWindow
{
	Q_OBJECT;
	
public:
	
	MainWindow(QWidget *parent = NULL);
	
	
protected slots:	
	
	///MLA,MRA,MRN Slots
	void MLA_elbowClicked();
	void MLA_pitchClicked();
	void MLA_yawClicked();
	void MLA_goClicked();
	void MRA_elbowClicked();
	void MRA_pitchClicked();
	void MRA_yawClicked();
	void MRA_goClicked();
	void MRN_pitchClicked();	
	void MRN_yawClicked();	
	void MRN_goClicked();
	
	void SaveEEPROMClicked();	
	void connectButtonClicked();	
	void disconnectButtonClicked();	
	void driveIndexChanged ( const QString & text );	
	void buttonBoxButtonClicked(QAbstractButton *button);	
	void SerialMessageReady(const SerialMessage& message);	
	void handleTxMessage();
	void updateTimer();
	void updateView();
	void sendCANMessage(const CANMessage& message);	
	
	
	void CtrlModeChanged(int value, int id);	
	void CtrlTypeChanged(int value, int id);	
	void SetPointSrcChanged(int value, int id);	
	void PosMesSrcChanged(int value, int id);		
	void SetPointChanged(int value, int id);	
	void SetPointMaxChanged(int value, int id);	
	void SetPointMinChanged(int value, int id);	
	void ADCOffsetChanged(int value, int id);
	void SpeedMaxChanged(int value, int id);
	void AccelerationStepChanged(int value, int id);
	void CurrentOffsetChanged(int value, int id);
	void CurrentLimitChanged(int value, int id);		
	void EncoderBiasChanged(int value, int id);
	void MotorBiasChanged(int value, int id);	
	void pid_KpChanged(double value, int id);	
	void pid_KiChanged(double value, int id);	
	void pid_KdChanged(double value, int id);
	void pid_error_maxChanged(double value, int id);
	void ScriptLoadClicked();
	void ScriptStartClicked();
	void ScriptStopClicked();
	void ScriptTimeout();
	
protected:
	
	void sendVariableData(unsigned int offset, unsigned char value);	
	void sendVariableData(unsigned int offset, short value);	
	void sendVariableData(unsigned int offset, float value);	
	
	//Script Actions
	void ScriptMLA(short elbow, short yaw, short pitch);
	void ScriptMRA(short elbow, short yaw, short pitch);
	void ScriptMRN(short pitch, short yaw);
	void ScriptMRE(char le_yaw, char le_yaw_speed, char re_yaw, char re_yaw_speed, char pitch, char pitch_speed);
	void ScriptMEB(char left_roll, char left_roll_speed, char right_roll, char right_roll_speed);
	void ScriptMRM(char ul_pos, char ul_speed, char ll_pos, char ll_speed, char ur_pos, char ur_speed, char lr_pos, char lr_speed);
	
	Ui::MLA *m_MLAWidget;
	Ui::MRA *m_MRAWidget;
	Ui::MRN *m_MRNWidget;
	DriveView* m_driveView[NB_DRIVE];
	SerialDriver* m_serialDriver;
	QList<SerialMessage> m_serialQueue;
	QTimer* m_updateTimer;
	QTimer* m_txHandler;
	QTimer* m_scriptTimer;
	int m_scriptIndex;
	GlobalVariables m_globalVariables;
	unsigned int m_offset;
	unsigned char m_selectedDrive;
};

#endif

