/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
 */

#ifndef _SERIAL_DRIVER_H_
#define _SERIAL_DRIVER_H_

#include "qextserialport.h"
#include <QObject>
#include <QString>
#include <QIODevice>
#include <QtDebug>
#include <QTimer>
#include "CANMessage.h"
#include "SerialMessage.h"



class SerialDriver : public QObject
	{
		Q_OBJECT;
		
	public:
		
		SerialDriver(QString comPort = "/dev/tty.usbserial", QObject *parent = NULL);
		
		inline int rxBytes(){return m_rxBytes;}
		inline int txBytes(){return m_txBytes;}
		inline int errorBytes(){return m_errorBytes;}

		
	signals:
		
		void messageReady(const SerialMessage &message);
		void connected();
		void disconnected();
		
		
		public slots:
		
		bool writeMessage(const SerialMessage& message);

		void openPort();

		
		protected slots:
		
		void readyRead();		
		void aboutToClose();		
		void testTimer();
		
		
	protected:
		
		void parseData(QByteArray &data);
		
		QByteArray m_buffer;
		QString m_comPort;
		PortSettings m_portSettings;
		QextSerialPort *m_serialPort;
		SerialMessage m_bufferedMessage;
		
#ifdef _TTY_POSIX_
		QTimer *m_readTimer;
#endif

		int m_rxBytes;
		int m_txBytes;
		int m_errorBytes;
		
		QTimer *m_testTimer;
		
	};





#endif
