/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
 */

#include "SerialMessage.h"

SerialMessage::SerialMessage()
{
	//clear all data
	memset(m_data,0,MESSAGE_SIZE);
	
	m_header[0] = 'c';
	m_header[1] = 'a';
	m_header[2] = 'n';
	
	m_size = MESSAGE_SIZE;
}

SerialMessage::SerialMessage(const SerialMessage &cpy)
{
	memcpy(m_data,cpy.m_data,MESSAGE_SIZE);
	m_size = cpy.m_size;
}


SerialMessage::SerialMessage(const CANMessage &message)
{
	
	//clear all data
	memset(m_data,0,MESSAGE_SIZE);
	
	m_header[0] = 'c';
	m_header[1] = 'a';
	m_header[2] = 'n';
	
	msg_priority = message.msg_priority;
	msg_type = message.msg_type;
	setMsgDataLength(message.msg_data_length);
	setMsgRtr(message.msg_remote);
	setMsgBoot(message.msg_read_write, message.msg_eeprom_ram);
	msg_command = message.msg_cmd;
	msg_destination = message.msg_dest;
	
	for (int i = 0; i < 8; i++)
	{
		msg_data[i] = message.msg_data[i];
	}
	
	m_size = MESSAGE_SIZE;
}

SerialMessage& SerialMessage::operator= (const SerialMessage& cpy)
{
	memcpy(m_data,cpy.m_data,MESSAGE_SIZE);
	m_size = cpy.m_size;
	return *this;
}


void SerialMessage::setMsgDataLength(unsigned char length)
{
	
	//using 4 bits
	msg_boot_rtr_length |= (length & 0x0F);
}

void SerialMessage::setMsgRtr(bool rtr)
{
	//using 1 bit
	if (rtr)
	{
		//set flag
		msg_boot_rtr_length |= (0x10);
	}
	else
	{
		//clear flag
		msg_boot_rtr_length &= (~0x10);
	}
}	


void SerialMessage::setMsgBoot(bool read_write, bool eeprom_ram)
{
	if (read_write)
	{
		//set flag
		msg_boot_rtr_length |= (0x20);
	}
	else
	{
		//clear flag
		msg_boot_rtr_length &= (~0x20);
	}
	
	if (eeprom_ram)
	{
		//set flag
		msg_boot_rtr_length |= (0x40);
	}
	else
	{
		//clear flag
		msg_boot_rtr_length &= (~0x40);
	}
}

void SerialMessage::setExtendedCmd(unsigned short cmd)
{
	msg_command = (cmd & 0x00FF);
	msg_priority = (cmd >> 8) & 0x0007;
}



void SerialMessage::print()
{
	qDebug() << "HEADER " << m_header[0] << m_header[1] << m_header[2];
	qDebug() << "PRIORITY " << msg_priority;
	qDebug() << "TYPE " << msg_type;
	qDebug() << "BOOT_RTR_LENGTH " << msg_boot_rtr_length;
	qDebug() << "DATA LENGTH " << (msg_boot_rtr_length & 0x0F);
	qDebug() << "RTR "<< ((msg_boot_rtr_length >> 4) & 0x01); 
	qDebug() << "READ_WRITE " << ((msg_boot_rtr_length >> 5) & 0x01);
	qDebug() << "EEPROM_RAM " << ((msg_boot_rtr_length >> 6) & 0x01);
	qDebug() << "CMD " << msg_command;
	qDebug() << "DEST " << msg_destination;
	for (int i = 0; i < (msg_boot_rtr_length & 0x0F); i++)
	{
		qDebug() << "DATA " << i<<" "<<msg_data[i];
	}
}

void SerialMessage::write(QIODevice &out) const
{
	//qDebug("SerialMessage::write() size: %i header: %c%c%c",m_size,m_header[0],m_header[1],m_header[2]);
	out.write(m_data,m_size);
}



