/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
 */


#ifndef _SERIAL_MESSAGE_H_
#define _SERIAL_MESSAGE_H_


#include "qextserialport.h"
#include <QObject>
#include <QString>
#include <QIODevice>
#include <QtDebug>
#include <QTimer>
#include "CANMessage.h"

#define MESSAGE_SIZE 16

/**
	This class data structure is intended for RS-232 communication with the Reddy controller.
	The union defined in this data structure is useful to handle CAN commands. However,
	the user can also use it to store any compatible command for reddy according to the
	RS-232 communication protocol.
 
	\Author Dominic Letourneau
*/
class SerialMessage
	{
	public:
		
		///You need to set the message size only if the message is not a CAN command
		int m_size;
		
		union {
			struct {
				///Message default header is 'c' 'a' 'n'
				unsigned char m_header[3];
				///CAN message priority
				unsigned char msg_priority;
				///CAN message type
				unsigned char msg_type;
				///CAN message boot code, RTR and length
				unsigned char msg_boot_rtr_length;
				///CAN message command
				unsigned char msg_command;
				///CAN command destination
				unsigned char msg_destination;
				///CAN message data
				unsigned char msg_data[8];
			} __attribute__((__packed__)) ;	//struct
			///You can byte access this union with this field
			char m_data[MESSAGE_SIZE];
		}; //union
		
		///Default constructor, will assume CAN message
		SerialMessage();		
		
		///Copy constructor
		SerialMessage(const SerialMessage &cpy);
		
		///Constructor with a CANMessage data structure
		SerialMessage(const CANMessage &message);
		
		///Operator =
		SerialMessage& operator= (const SerialMessage& cpy);
		
		///Set the CAN message data length field
		void setMsgDataLength(unsigned char length);
		
		///Set the CAN message RTR field
		void setMsgRtr(bool rtr);		
		
		///Set the CAN message Boot field
		void setMsgBoot(bool read_write, bool eeprom_ram);
		
		///Set the Extended CMD field
		void setExtendedCmd(unsigned short cmd);		
		
		///Print the RS-232 data members
		void print();
		
		///Write to IODevice
		void write(QIODevice &out) const;		
	};


#endif

