/**
 Copyright (C) 2009 IntRoLab
 http://introlab.gel.usherbrooke.ca
 Dominic Létourneau, ing. M.Sc.A.
 Dominic.Letourneau@USherbrooke.ca
 */
#ifndef _SharedVariables_H_
#define _SharedVariables_H_

typedef struct _SharedVariables
	{
		union {
			struct {
				unsigned char CtrlMode;
				unsigned char CtrlType;
				
				unsigned char SetPointSource;	
				unsigned char PosMesSource;
				
				
				unsigned short ErrorCode;
				
				short SetPoint;
				short SetPointMax; //Maximum SetPoint
				short SetPointMin; //Minimum SetPoint
				
				short Current;
				short CurrentOffset;
				
				short ADCValue;
				short ADCOffset;
				
				short ICValue;
				short ICOffset;
				
				
				short ThermalState;
				
				//CONTROL VARIABLES
				short Speed;//16 bit speed
				short Position; //16 bits position
				short Acceleration;
				
				//PID REF AND MES POINT
				short RefPoint; 
				short MesPoint;
				
				float pid_kp;
				float pid_ki;
				float pid_kd;
				float pid_error;
				float pid_error_accum;
				float pid_error_derivative;
				float pid_error_accum_max; //PID I value max limit (abs)
				
				
				short PIDOut;
				
				//RAM LOC7 (PID + TRAPZ VARIABLES)
				
				short SpeedMax; //for Trapz 
				short AccelerationStep; //for Trapz, Speed
				
				
				//RAM LOC8 (TRAPZ VARIABLES)
				short InitPoint; //for Trapz
				short DestPoint; //for Trapz
				short NextPoint; //for Trapz
				
				
				//RAM LOC9 (CURRENT LIMIT)
				short CurrentLimit; //unit = mA
				short PWM_CurrentLimit;
				short PWM_CurrentStep; //PWM increment
				unsigned char CurrentLimitActive;
				
				unsigned char EncoderBias; //Setting this to 1 will invert the encoder sign
				unsigned char MotorBias; //Setting this to 1 will invert motor polarity
				
				unsigned char padding[3];
			} __attribute__((packed));
			
			unsigned char m_data[];
		};
	} SharedVariables;


typedef struct _GlobalVariables
	{
		union {
			struct {
				
				//All control variables
				SharedVariables m_variables[4];
				
				//additional (global) variables
				unsigned char m_ESTOPEnabled;
				unsigned char m_WriteEEPROM;
				short m_loopTime;
				
				unsigned char m_padding[4];
				
			} __attribute__((packed));
		
			unsigned char m_data[];
		};//union
	} GlobalVariables;	

#endif


