//////////////////////////////////////////////////////////////////////
//   analogique.c
//////////////////////////////////////////////////////////////////////
//
//   Description: Library for pic18F458 to initialize and capture analogue port
//				  
//                
//
//   Name: Dominic Ltourneau, Pierre Lepage
//   Date de cration : 2006/10/06
//
//   Modification:
//
//   Nom                   Date          Description
//	 
//
//////////////////////////////////////////////////////////////////////
//               Copyright by RoboMotio inc.  2006
//////////////////////////////////////////////////////////////////////

#ifndef _ANALOGIQUE_C_
#define _ANALOGIQUE_C_
//Include
#include <p18F458.h>
#include "analogique.h"
#include <adc.h>
#include <delays.h>


//////////////////////////////////////////////////////////////////////
//   init_analog
//////////////////////////////////////////////////////////////////////
//
//   Description: initialise analog input
//
//   Input: void
//   Output: NONE
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
void init_analog(void)
{
	//Set analog lines inputs
	TRISAbits.TRISA0 = 1;
	TRISAbits.TRISA1 = 1;
	TRISAbits.TRISA2 = 1;
	TRISAbits.TRISA3 = 1;
	TRISAbits.TRISA5 = 1;

	TRISEbits.TRISE0 = 1;
	TRISEbits.TRISE1 = 1;
	TRISEbits.TRISE2 = 1;
	
  OpenADC (ADC_FOSC_RC &
	ADC_RIGHT_JUST &
	ADC_7ANA_1REF, 
	ADC_CH0 &
	ADC_CH1 &
	ADC_CH2 &
	ADC_CH4 &
	ADC_CH5 &
	ADC_CH6 &
	ADC_CH7 &
	ADC_INT_OFF); 
}


//////////////////////////////////////////////////////////////////////
//   get_batt2
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from Batt2
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_batt2(void)
{
	SetChanADC(BATT_2);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}

//////////////////////////////////////////////////////////////////////
//   get_batt1
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from Batt1
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_batt1(void)
{
	SetChanADC(BATT_1);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}

//////////////////////////////////////////////////////////////////////
//   get_raw_input_1
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from RA0
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_raw_input_1(void)
{
	SetChanADC(INPUT_1);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}
//////////////////////////////////////////////////////////////////////
//   get_raw_input_2
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from RA1
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_raw_input_2(void)
{
	SetChanADC(INPUT_2);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}
//////////////////////////////////////////////////////////////////////
//   get_raw_input_3
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from RA2
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_raw_input_3(void)
{
	SetChanADC(INPUT_3);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}
//////////////////////////////////////////////////////////////////////
//   get_raw_input_4
//////////////////////////////////////////////////////////////////////
//
//   Description: get raw data from RA5
//
//   Input: void
//   Output: unsigned int16 (read adc value)
//   Input/Output: NONE
//   Returned value: NONE
//
//////////////////////////////////////////////////////////////////////
unsigned int get_raw_input_4(void)
{
	SetChanADC(INPUT_4);
	Delay100TCYx(1);   //10 us delay
	ConvertADC();
	while(BusyADC());
	//Reading on 10 bits
	return ReadADC();
}
#endif
