//////////////////////////////////////////////////////////////////////
//   can18_driver.h
//////////////////////////////////////////////////////////////////////
//
//   Description: Specialised Can Driver for 18xxx8
//
//   Nom: Pierre Lepage, Dominic Ltourneau
//   Date de cration : 2004/06/24
//
//   Histoire des modifications:
//
//   Nom                   Date        Descrition
//
//////////////////////////////////////////////////////////////////////
//               Copyright by Laborius  2002/10/30
//////////////////////////////////////////////////////////////////////
#ifndef _CAN18_DRIVER_H_
#define _CAN18_DRIVER_H_

/* LABORIUS VARIABLE SECTION ################################################################# */
/*
MESSAGE PRIORITY DEFINITIONS
*/
#define CAN_PRIORITY_HIGHEST     0
#define CAN_PRIORITY_HIGH        1
#define CAN_PRIORITY_MEDIUM_HIGH 2
#define CAN_PRIORITY_MEDIUM      3
#define CAN_PRIORITY_MEDIUM_LOW  4
#define CAN_PRIORITY_LOW         5
#define CAN_PRIORITY_LOWEST      6
#define CAN_PRIORITY_EVENTS      7

/*
MESSAGE TYPE DEFINITIONS
*/
#define CAN_TYPE_EMERGENCY                0x01
#define CAN_TYPE_ACTUATOR_HIGH_PRIORITY   0x02
#define CAN_TYPE_SENSOR_HIGH_PRIORITY     0x04
#define CAN_TYPE_ACTUATOR_LOW_PRIORITY    0x08
#define CAN_TYPE_SENSOR_LOW_PRIORITY      0x10
#define CAN_TYPE_REQUEST_DATA             0x20
#define CAN_TYPE_USER2                    0x40
#define CAN_TYPE_EVENTS                   0x80

#define NOTHING                           0xFF

/*
SENSOR COMMANDS
*/
#define CAN_SENSOR_GET_SENSOR			0x20
#define CAN_SENSOR_EMERGENCY_RF			0x21
/*
ALIMENTATION COMMAND
*/
#define CAN_SENSOR_E_STOP_ON			0x10
#define CAN_SENSOR_E_STOP_OFF			0x11
#define CAN_ALIM_DATA_1					0x12
#define CAN_ALIM_DATA_2					0x13
/*
ACTUATOR COMMANDS
*/
#define CAN_DRIVE_SET_POINT           	0x01
#define CAN_DRIVE_DATA_1				0x02
#define CAN_DRIVE_DATA_2				0x03
#define CAN_DRIVE_MODE					0x04
#define CAN_DRIVE_CURRENT_LIMIT			0x05
#define CAN_DRIVE_PID_CHANGE			0x06
#define CAN_DRIVE_SPEED_PROFIL			0x07
#define CAN_DRIVE_START_POS				0x08
#define CAN_DRIVE_ACTIVATE_MOTOR		0x09
#define CAN_DRIVE_NORMALISATION			0x0A
#define CAN_DRIVE_BIAS					0x0B
#define CAN_DRIVE_RESET_A3932			0x0C
/*
SERVOS COMMANDS
*/
#define CAN_SERVO_SET_POINT				0x30
#define CAN_SERVO_GET_POINT				0x31

/*
EMERGENCY MESSAGE COMMANDS (TYPE_EMERGENCY)
*/
#define CAN_EMERGENCY_CMD_RESET        0x00
#define CAN_EMERGENCY_CMD_STOP_ENABLE  0x01
#define CAN_EMERGENCY_CMD_DISCONNECT   0x02
#define CAN_EMERGENCY_CMD_RECONNECT    0x03
#define CAN_EMERGENCY_CMD_PROGRAM      0x04
#define CAN_EMERGENCY_CMD_STOP_DISABLE 0x05

#define CAN_REQUEST_READ                0x01
#define CAN_REQUEST_WRITE               0x00

#define CAN_REQUEST_EEPROM              0x01
#define CAN_REQUEST_RAM                 0x00

/*
EVENTS MESSAGE COMMANDS (TYPE EVENTS)
*/

#define CAN_EVENTS_CMD_ALIVE           	0x00
#define CAN_EVENTS_CMD_REGISTER        	0x01  // unused
#define CAN_EVENTS_CMD_SILENCE			0x02

/*
EVENTS MESSAGE COMMANDS (TYPE SENSOR_HIGH_PRIORITY)
*/

/*
CAN ADDRESS DEFINITIONS
*/
#define CAN_ADDRESS_BROADCAST 0xFF

/*
STRUCTURES
*/

typedef struct _message{
   unsigned char msg_priority;
   unsigned char msg_type;
   unsigned char msg_cmd;
   unsigned char msg_dest;
   unsigned char msg_read_write;
   unsigned char msg_eeprom_ram;
   unsigned char msg_data_length;
   unsigned char msg_data[8];
   unsigned char msg_remote;
   unsigned char msg_filter_hit;
   unsigned char msg_overflow;
} LABORIUS_MESSAGE;

typedef struct _filter {
   unsigned char filter_priority;
   unsigned char filter_type;
   unsigned char filter_cmd;
   unsigned char filter_dest;
} LABORIUS_FILTER;

typedef struct _mask {
   unsigned char mask_priority;
   unsigned char mask_type;
   unsigned char mask_cmd;
   unsigned char mask_dest;
} LABORIUS_MASK;





// DATA_FLOW_TABLE Stuff
// ADDR, OFFSET, LIMITS on memory
#define DATA_FLOW_ENTRY             0x08
#define MAX_RAM_DATA_ENTRY          0x80
#define MAX_EEPROM_DATA_ENTRY       0x80
#define BIT_SET_LIMITS              0x07
#define SECTION_MASK                0x0F
#define SUB_SECTION_MASK            0xF0
#define SUB_SECTION_SHIFT           0x04
#define NUM_SECTION					16

//READ_WRITE MEMORY
#define READ_WRITE_1_BYTE           0x08
#define READ_WRITE_2_BYTE           0x09
#define READ_WRITE_3_BYTE           0x0A
#define READ_WRITE_4_BYTE           0x0B
#define READ_WRITE_5_BYTE           0x0C
#define READ_WRITE_6_BYTE           0x0D
#define READ_WRITE_7_BYTE           0x0E
#define READ_WRITE_8_BYTE           0x0F

#define READ_WRITE_BIT_0            0x00
#define READ_WRITE_BIT_1            0x01
#define READ_WRITE_BIT_2            0x02
#define READ_WRITE_BIT_3            0x03
#define READ_WRITE_BIT_4            0x04
#define READ_WRITE_BIT_5            0x05
#define READ_WRITE_BIT_6            0x06
#define READ_WRITE_BIT_7            0x07

/////////////////////////////////////////////////////////////////
//    MEMORY ORGANISATION
//
//    SECTION_ID                       INDEX       MEANING
//    -----------------------------------------------------------
//    CAN_REQUEST_DATA_FLOW_00         0           TABLE VERSION
//    CAN_REQUEST_DATA_FLOW_00         1           PROJECT ID
//    CAN_REQUEST_DATA_FLOW_00         2           GENERAL ID
//    CAN_REQUEST_DATA_FLOW_00         3           MODULE  ID
//    CAN_REQUEST_DATA_FLOW_00         4           CODE VERSION
//    CAN_REQUEST_DATA_FLOW_00         5           STATE OF CONTROLER
//
/////////////////////////////////////////////////////////////////

//MODE ID USED when TYPE = CAN_TYPE_EVENTS and cmd
#define CAN_NORMAL_MODE_ID          0x05
#define CAN_BOOT_MODE_ID            0x0A
#define CAN_IDLE_MODE_ID            0x0B




#define TRUE 1
#define FALSE 0

/* unsigned charERNAL DRIVER VARIABLE SECTION ################################################################# */
//SPECIFIC INITIALIZATION OF CAN LIBRARY
#define CAN_DO_DEBUG                FALSE
#define CAN_USE_EXTENDED_ID         TRUE
#define CAN_BRG_SYNCH_JUMP_WIDTH    0       //synchronized jump width (def: 1 x Tq)
#define CAN_BRG_PRESCALAR           0       //baud rate generator prescalar (def: 4) ( Tq = (2 x (PRE + 1))/Fosc )
#define CAN_BRG_SEG_2_PHASE_TS      TRUE    //phase segment 2 time select bit (def: freely programmable)
#define CAN_BRG_SAM                 0       //sample of the can bus line (def: bus line is sampled 1 times prior to sample pounsigned char)
#define CAN_BRG_PHASE_SEGMENT_1     7       //phase segment 1 (def: 6 x Tq)
#define CAN_BRG_PROPAGATION_TIME    2       //propagation time select (def: 3 x Tq)
#define CAN_BRG_WAKE_FILTER         FALSE   //selects can bus line filter for wake up bit
#define CAN_BRG_PHASE_SEGMENT_2     7       //phase segment 2 time select (def: 6 x Tq)
#define CAN_USE_RX_DOUBLE_BUFFER    TRUE    //if buffer 0 overflows, do NOT use buffer 1 to put buffer 0 data
#define CAN_ENABLE_DRIVE_HIGH       1
#define CAN_ENABLE_CAN_CAPTURE      0

enum CAN_OP_MODE {CAN_OP_CONFIG=4, CAN_OP_LISTEN=3, CAN_OP_LOOPBACK=2, CAN_OP_DISABLE=1, CAN_OP_NORMAL=0};
enum CAN_WIN_ADDRESS {CAN_WIN_RX0=0, CAN_WIN_RX1=5, CAN_WIN_TX0=4, CAN_WIN_TX1=3, CAN_WIN_TX2=2};
enum CAN_int_CODE {CAN_int_WAKEUP=7, CAN_int_RX0=6, CAN_int_RX1=5, CAN_int_TX0=4, CAN_int_TX1=3, CAN_int_TX2=2, CAN_int_ERROR=1, CAN_int_NO=0};

/*
#define RX0MASK &RXM0EIDL
#define RX1MASK &RXM1EIDL
#define RX0FILTER0 &RXF0EIDL
#define RX0FILTER1 &RXF1EIDL
#define RX1FILTER2 &RXF2EIDL
#define RX1FILTER3 &RXF3EIDL
#define RX1FILTER4 &RXF4EIDL
#define RX1FILTER5 &RXF5EIDL

#define RXB0ID &RXB0EIDL
#define RXB1ID &RXB1EIDL
#define TXB0ID &TXB0EIDL
#define TXB1ID &TXB1EIDL
#define TXB2ID &TXB2EIDL
*/

/*
#define TXRXBaID     0xF64
*/

enum CAN_RX_MODE {CAN_RX_ALL=3, CAN_RX_EXT=2, CAN_RX_STD=1, CAN_RX_VALID=0};

//value to put in mask field to accept all incoming id's
#define CAN_MASK_ACCEPT_ALL   0

/* LABORIUS FUNCTIONS' PROTOTYPE ########################################################################*/
void can_apply_accept_mask(LABORIUS_MASK *mask, unsigned char mask_id);
void can_apply_filter(LABORIUS_FILTER *filter, unsigned char filter_id);
unsigned char can_send_laborius_packet(LABORIUS_MESSAGE *message);
unsigned char can_recv_laborius_packet(LABORIUS_MESSAGE *message);
void can_send_im_alive(unsigned char can_addr);
void can_transceiver(unsigned char can_addr);

// Dans chaque projet qui utilise le can, vous devez dfinir la fonction
// suivante dans votre code.
extern void proc_message(LABORIUS_MESSAGE *message);

extern volatile unsigned char DATA_FLOW_TABLE[128];
extern unsigned char data_flow_buffer[8];

//Read and Write functions
unsigned char read_data_flow_table(unsigned char section_id,unsigned char sub_section_id,unsigned char mem_type, unsigned char *buffer);
unsigned char write_data_flow_table(unsigned char section_id,unsigned char sub_section_id,unsigned char mem_type, unsigned char *buffer);

unsigned char eeprom_hit(void);

/* unsigned charERNAL DRIVER FUNCTIONS PROTOTYPE ####################################################################*/
void  can_init(LABORIUS_FILTER *filter,LABORIUS_MASK *mask);
void  can_set_baud(void);
void  can_set_mode(unsigned char mode);

void can_write_eeprom(unsigned char addr, unsigned char data);
unsigned char can_read_eeprom(unsigned char addr);

#endif
