//////////////////////////////////////////////////////////////////////
//   main.h
//////////////////////////////////////////////////////////////////////
//
//   Description: Functions initialization 
//
//
//   Name: Pierre Lepage
//   Date de cration : 2006/10/06
//
//   Modification:
//
//   Name                  Date          Description
//	 Pierre Lepage		   2006-12-05	 adding : pooling_whisker_detection
//	 Pierre Lepage		   2006-12-05    adding : limit_position
//
//////////////////////////////////////////////////////////////////////
//               Copyright by RoboMotio inc.  2006
//////////////////////////////////////////////////////////////////////

#ifndef _MAIN_H_
#define _MAIN_H_

#define MAX_TIMER		0xFFFF	//65 535

#define CMD_MRA		320
#define CMD_MLA		314
#define CMD_MRE		324
#define CMD_MEB		308
#define CMD_MRM		332
#define CMD_MRN		333
#define CMD_MSS		339
#define CMD_GBV		319
#define CMD_GWS		337
#define CMD_GAV		318
#define CMD_CAN		306

#define ELBOW_RIGHT				1
#define SHOULDER_YAW_RIGHT		2
#define SHOULDER_PITCH_RIGHT	3
#define ELBOW_LEFT				6
#define SHOULDER_YAW_LEFT		7
#define SHOULDER_PITCH_LEFT		4
#define NECK_YAW				8
#define NECK_PITCH				9
#define MOUTH_UPPER_RIGHT		11
#define MOUTH_LOWER_RIGHT		14
#define MOUTH_UPPER_LEFT		13
#define MOUTH_LOWER_LEFT		12
#define EYES_PITCH				15
#define EYE_YAW_LEFT			16
#define EYE_YAW_RIGHT			17
#define EYEBROW_RIGHT			18
#define EYEBROW_LEFT			20

//Normalisation section
//With this normalisation, we have an output error of 400 ns
//For servo Going from 0-180
// 0   = 65 285
// 90  = 64 285
// 180 = 63 285
// Equation used : CAN_ANGLE = 65 285 - [norm(SERIAL_ANGLE)]
#define Basic_Multiplication_180			3
#define Norm_Multiplication_180			237
#define Norm_Shifting_180				6

//For servo going from 0-90 (only the norm_shifting change)
// 0   = 65 285
// 45  = 64 285
// 90  = 63 285
#define Basic_Multiplication_90		3
#define Norm_Multiplication_90		237
#define Norm_Shifting_90			5

//For servo going from 0-270 (basic_multiplication & norm_shifting change)
// 0   = 65 285
// 135  = 64 285
// 270  = 63 285
#define Basic_Multiplication_270		1
#define Norm_Multiplication_270		237
#define Norm_Shifting_270			5

//Normalisation constant
#define BASED_CAN_DEGREE		65285

typedef struct{
	//INTERNAL
	unsigned char str_index;
	unsigned int  str_id;
	unsigned char str_header;
	unsigned char str_params_index;
	unsigned char str_params_buffer[16];
}RCV_STRING;

typedef struct{
	//INTERNAL
	unsigned char str_ready;
	unsigned int cmd_id;
	unsigned char whisker_state;
	unsigned char whisker_requested;
	unsigned int battery_1_volt;
	unsigned int battery_2_volt;
	unsigned char battery_requested;
	unsigned char analogue_requested;
	unsigned int analogue_1_value;
	unsigned int analogue_2_value;
	unsigned int analogue_3_value;
	unsigned int analogue_4_value;
// Addon 5 Dec 2006 ---------------------------------------
	unsigned char old_state_RB4;
	unsigned char old_state_RB5;
	unsigned char old_state_RB6;
	unsigned char old_state_RB7;
}CTRL_PARAMS;

void init_ctrl_params(void);
void init_rcv_string(void);
void init_face(void);

void led(void);
void input_parser(unsigned char value);
void do_action(void);
void whisker_detection(void);
void pooling_whisker_detection(void);

unsigned int norm_servo(unsigned char serial_value, unsigned short long multiplicator, unsigned char shift, unsigned int base_tick, unsigned char inversion);
unsigned int norm_servo_270(unsigned char serial_value); //Depricated
unsigned int norm_servo_180(unsigned char serial_value);//Depricated
unsigned int norm_servo_90(unsigned char serial_value);//Depricated
unsigned char get_servo_id(unsigned char servo_alias);
void send_whisker_state(void);
void battery_detection(void);
void analogue_detection(void);
void send_battery_state(void);
unsigned int limit_position(unsigned char servo_alias, unsigned int value);

#endif
