//////////////////////////////////////////////////////////////////////
//   serial_driver.c
//////////////////////////////////////////////////////////////////////
//
//   Description: Initialize serial line and allow string to be sent on it
//				  Library for a computer interface using the RS-232 port.
//                
//
//   Name: Dominic Ltourneau, Pierre Lepage
//   Date de cration : 2006/10/06
//
//   Modification:
//
//   Nom                   Date          Description
//	 
//
//////////////////////////////////////////////////////////////////////
//               Copyright by RoboMotio inc.  2006
//////////////////////////////////////////////////////////////////////

#ifndef _SERIAL_DRIVER_C_
#define _SERIAL_DRIVER_C_

#include <delays.h>
#include <usart.h>

void init_serial(void) {

	unsigned char dummy;

    //Setup USART 57600 baud with 40 MHZ clock.
	//Baud Equation
	//HIGH SPEED (/16)
	//spbrg = ((FOSC/Desired_Baud_Rate)/16)-1

	//LOW SPEED (/64)
	//spbrg = ((FOSC/Desired_Baud_Rate)/64)-1
/*
	//115 200
	OpenUSART(USART_TX_INT_OFF &
		USART_RX_INT_ON &
		USART_ASYNCH_MODE &
		USART_EIGHT_BIT &
		USART_CONT_RX &
		USART_BRGH_HIGH,
		21);
*/

	//57600
	OpenUSART(USART_TX_INT_OFF &
		USART_RX_INT_ON &
		USART_ASYNCH_MODE &
		USART_EIGHT_BIT &
		USART_CONT_RX &
		USART_BRGH_HIGH,
		42);

/*
	//19200
	OpenUSART(USART_TX_INT_OFF &
		USART_RX_INT_ON &
		USART_ASYNCH_MODE &
		USART_EIGHT_BIT &
		USART_CONT_RX &
		USART_BRGH_HIGH,
		129);
*/
/*
	//9600	
	OpenUSART(USART_TX_INT_OFF &
		USART_RX_INT_ON &
		USART_ASYNCH_MODE &
		USART_EIGHT_BIT &
		USART_CONT_RX &
		USART_BRGH_LOW,
		64);
*/
	//this will clear receive flag
    dummy = RCREG;
}

void send_s_serial(char *data, unsigned char data_lenght)
{
	unsigned char i = 0;
	unsigned int retry_counter = 0;

	//wait until we are ready to send data
	//Send the data
	for(i=0;i<data_lenght;i++){
		while(BusyUSART());
		putcUSART(data[i]);
	}
}

#endif
